/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.ws.listener.utils.WSListenerProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWWSRMPanel
extends VWTaskTabPanel {
    VWManagerNode m_node = null;
    JTextField m_clientListenerPort = null;
    JTextField m_InactivityTimeout = null;
    JTextField m_BaseRetransmissionInterval = null;

    public VWWSRMPanel(VWManagerNode node) {
        this.m_node = node;
        this.initLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyProperties() throws VWException {
        WSListenerProperties props = this.m_node.getWSListenerProperties();
        if (props == null) {
            return;
        }
        WSListenerProperties wSListenerProperties = props;
        synchronized (wSListenerProperties) {
            props.WSRMSetProperties(this.m_clientListenerPort.getText(), this.m_InactivityTimeout.getText(), this.m_BaseRetransmissionInterval.getText(), "200");
        }
    }

    public void validateTextFields() throws VWException {
        String s = this.m_clientListenerPort.getText();
        boolean isValid = false;
        if (s != null) {
            try {
                int port = Integer.parseInt(s);
                if (port >= 0 && port < 65536) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!isValid) {
            throw new VWException("vw.apps.taskman.VWWSRMPanel.invalidValueForClientListenerPort", "Invalid value specified for ''{0}'' property.", this.m_clientListenerPort.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetProperties() {
        try {
            WSListenerProperties props = this.m_node.getWSListenerProperties();
            if (props == null) {
                return;
            }
            WSListenerProperties wSListenerProperties = props;
            synchronized (wSListenerProperties) {
                this.m_clientListenerPort.setText(props.getDynamicClientListenerPort());
                this.m_InactivityTimeout.setText(props.getProperty("filenet.wsrm.inactivity.timeout", "600000"));
                this.m_BaseRetransmissionInterval.setText(props.getProperty("filenet.wsrm.base.retransmission.interval", "3000"));
            }
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while re-getting properties from WSListenerProperties.");
        }
    }

    protected void updateState(boolean enabled) {
        this.m_clientListenerPort.setEditable(enabled);
        this.m_InactivityTimeout.setEditable(enabled);
        this.m_BaseRetransmissionInterval.setEditable(enabled);
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 21;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 5, 5);
        this.m_clientListenerPort = new JTextField("");
        this.m_clientListenerPort.setName(VWResource.WSRMClientListenerPort);
        this.m_clientListenerPort.addFocusListener(this);
        this.add((Component)new JLabel(this.m_clientListenerPort.getName() + ":"), c);
        ++c.gridy;
        this.m_InactivityTimeout = new JTextField("");
        this.m_InactivityTimeout.setName(VWResource.WSRMInactivityTimeout);
        this.m_InactivityTimeout.addFocusListener(this);
        this.add((Component)new JLabel(this.m_InactivityTimeout.getName() + ":"), c);
        ++c.gridy;
        this.m_BaseRetransmissionInterval = new JTextField("");
        this.m_BaseRetransmissionInterval.setName(VWResource.WSRMBaseRetransmissionInterval);
        this.m_BaseRetransmissionInterval.addFocusListener(this);
        this.add((Component)new JLabel(this.m_BaseRetransmissionInterval.getName() + ":"), c);
        ++c.gridy;
        ++c.gridx;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((JTextComponent)this.m_clientListenerPort, (Object)c, false);
        ++c.gridy;
        this.add((JTextComponent)this.m_InactivityTimeout, (Object)c, false);
        ++c.gridy;
        this.add((JTextComponent)this.m_BaseRetransmissionInterval, (Object)c, false);
        this.resetProperties();
    }

    public String getHelpPage() {
        return VWHelp.Help_Process_TaskManager + "cm_config_ws.htm";
    }
}

